/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import noppes.npcs.LogWriter;

public class Resistances {
    public static final List<String> allDamageNames = new ArrayList<String>();
    public final Map<String, Float> data = new HashMap<String, Float>();

    public Resistances() {
        this.data.put("arrow", Float.valueOf(1.0f));
        this.data.put("mob", Float.valueOf(1.0f));
        this.data.put("knockback", Float.valueOf(1.0f));
        this.data.put("explosion", Float.valueOf(1.0f));
        allDamageNames.add("arrow");
        allDamageNames.add("mob");
        allDamageNames.add("knockback");
        allDamageNames.add("explosion");
        for (Field f : DamageSource.class.getDeclaredFields()) {
            if (f.getType() != DamageSource.class) continue;
            try {
                String name;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((name = ((DamageSource)f.get(DamageSource.class)).field_76373_n).equals("generic") || name.equals("outOfWorld")) continue;
                allDamageNames.add(name);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
    }

    public float applyResistance(DamageSource source, float damage) {
        if (source.field_76373_n.equals("arrow") || source.field_76373_n.equals("thrown") || source.func_76352_a()) {
            damage *= 2.0f - this.data.get("arrow").floatValue();
        } else if (source.field_76373_n.equals("player") || source.field_76373_n.equals("mob")) {
            damage *= 2.0f - this.data.get("mob").floatValue();
        } else if (source.field_76373_n.equals("explosion") || source.field_76373_n.equals("explosion.player")) {
            damage *= 2.0f - this.data.get("explosion").floatValue();
        } else if (this.data.containsKey(source.field_76373_n)) {
            damage *= 2.0f - this.data.get(source.field_76373_n).floatValue();
        }
        return damage;
    }

    public void readToNBT(NBTTagList list) {
        this.data.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            String key = nbt.func_74779_i("K");
            this.data.put(key, Float.valueOf(nbt.func_74760_g("V")));
            if (allDamageNames.contains(key)) continue;
            allDamageNames.add(key);
        }
    }

    public void oldReadToNBT(NBTTagCompound compound) {
        this.data.put("arrow", Float.valueOf(compound.func_74760_g("Arrow")));
        this.data.put("mob", Float.valueOf(compound.func_74760_g("Melee")));
        this.data.put("knockback", Float.valueOf(compound.func_74760_g("Knockback")));
        this.data.put("explosion", Float.valueOf(compound.func_74760_g("Explosion")));
    }

    public NBTTagList writeToNBT() {
        NBTTagList list = new NBTTagList();
        for (String key : this.data.keySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("K", key);
            nbt.func_74776_a("V", this.data.get(key).floatValue());
            list.func_74742_a((NBTBase)nbt);
        }
        return list;
    }

    public float get(String damageName) {
        if (this.data.containsKey(damageName)) {
            return this.data.get(damageName).floatValue();
        }
        if (damageName.equals("explosion.player") && this.data.containsKey("explosion")) {
            return this.data.get("explosion").floatValue();
        }
        if (damageName.equals("player") && this.data.containsKey("mob")) {
            return this.data.get("mob").floatValue();
        }
        if (damageName.equals("thrown") && this.data.containsKey("arrow")) {
            return this.data.get("arrow").floatValue();
        }
        return 1.0f;
    }

    public static void addDamageName(String damageType) {
        if (damageType == null || damageType.isEmpty() || allDamageNames.contains(damageType) || damageType.equals("null") || damageType.equals("thrown") || damageType.equals("player") || damageType.equals("explosion.player") || damageType.equals("generic") || damageType.equals("outOfWorld")) {
            return;
        }
        allDamageNames.add(damageType);
        Collections.sort(allDamageNames);
    }
}

